//*********************************************************************************
//**
//** Platform........: ATMEL ATmega or AT90 series of Microcontrollers
//**
//** Licence.........: This software is freely available for non-commercial 
//**                   use only - i.e. for research and experimentation.
//**
//**                   Bipolar Stepper Motor Control Routine,
//**                   using 2x Allegro A4975 Microstepping
//**                   Full-Bridge Motor Drivers 
//**
//**
//**                   2012-10-20, Loftur Jonasson, TF3LJ
//**
//*********************************************************************************


#include "ML.h"

const uint8_t out_seq[]= {	0xcc,0xbd,0xae,0x9f,// As per A4975 Datasheet
							0x0f,0x1f,0x2e,0x3d,// "Table 4 - Step Sequencing"	
							0x4c,0x5b,0x6a,0x79,// Order of bits is:
							0x70,0x71,0x62,0x53,// b7, b6, b5, b4, b3, b2, b1, b0
							0x44,0x35,0x26,0x17,// PhA,D2A,D1A,D0A,PhB,D2B,D1B,D0B
							0x07,0x97,0xa6,0xb5,// where A denotes Bridge A
							0xc4,0xd3,0xe2,0xf1,// and   B denotes Bridge B
							0xf0,0xf9,0xea,0xdb };

uint8_t phase=0;	// tracks the current step out of a total of 32
//uint16_t zz;

//
// Init Stepper Outputs
//
void stepper_Init(void)
{
	//
	// Set outputs
	//
	STEP_DDR = 0xff;							// Enable 8 pins for output
	STEP_PORT = 0x00;							// Start with no current applied
}

//
// Increment Stepper
//
void stepper_Incr(void)
{
	phase++;
	if (phase > 31) phase = 0;
	STEP_PORT = out_seq[phase];

	//zz++;
	//lcdGotoXY(10,1);
	//rprintf("%5u %x i",zz, out_seq[phase]);
}
//
// Decrement Stepper
//
void stepper_Decr(void)
{
	phase--;
	if (phase > 31) phase = 31;
	STEP_PORT = out_seq[phase];

	//zz--;
	//lcdGotoXY(10,1);
	//rprintf("%5u %x d",zz, out_seq[phase]);
}

void stepper_PwrOff(void)
{
	STEP_PORT = 0;
}
